local t = Def.ActorFrame {Name = "SpeedistLuaFile",}

local function getPlayerOptionPreferred(funcname)
    local poptions = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions("ModsLevel_Preferred")
    return poptions[funcname](poptions)
end

-- made for etterna, should be compatible with sm5.1
local function setPlayerOptionsModValueAllLevels(funcname, ...)
    -- you give a funcname like MMod, XMod, CMod and it just works
    local poptions = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions("ModsLevel_Preferred")
    local stoptions = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions("ModsLevel_Stage")
    local soptions = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions("ModsLevel_Song")
    local coptions = GAMESTATE:GetPlayerState(PLAYER_1):GetPlayerOptions("ModsLevel_Current")
    poptions[funcname](poptions, ...)
    stoptions[funcname](stoptions, ...)
    soptions[funcname](soptions, ...)
    coptions[funcname](coptions, ...)
end

-- notes
-- - when mmod is set, xmod is also set to 1. be careful there
-- - when cmod or xmod is set, that is the only value. the others return nil
-- - to get the value of a player option, call the method with no arguments
-- - to set the value of a player option, call the method with the argument required
-- - strange custom speeds can be set using these PlayerOptions methods (DIDNT TEST, HOPE TO GOD NOBODY USES THESE):
--  - TimeSpacing(float), MaxScrollBPM(float), ScrollSpeed(float), ScrollBPM(float), RandomSpeed(float)
--  - FromString(string) - this one can do a lot of unintended things
-- - saying "if self.xmodValue then" just happens to work because we arent allowed to have speed mod set to 0
-- - otherwise this would fail in some cases

-- this is the intended xmod value we want to be at
-- like 1 is 1x
-- local intendedXmodValue = 7.2

local function findXmodEquivalent(value)
    -- usually cmod or mmod / bpm gives the right number

    -- set this as the "static bpm" of the file
    -- basically if most bpms in this file are 100, set it to 100
    local bpmgoal = 125

    local rate = 1
    if GAMESTATE.GetSongOptionsObject and GAMESTATE:GetSongOptionsObject("ModsLevel_Current") ~= nil then
        rate = GAMESTATE:GetSongOptionsObject("ModsLevel_Current"):MusicRate() or 1
    end

    return value / (bpmgoal * rate)
end

t[#t+1] = Def.Actor {
    Name = "Speedist",
    InitCommand = function(self)
        self.xmodValue = getPlayerOptionPreferred("XMod")
        self.cmodValue = getPlayerOptionPreferred("CMod")
        self.mmodValue = getPlayerOptionPreferred("MMod")

        -- dont remove this if you want to use the xmod value the player already had it set to, if it was already set
        -- (only applies for xmod)
        if self.xmodValue and not self.mmodValue then
            intendedXmodValue = self.xmodValue
        end

        -- remove this if you want to force the intendedXmodValue and dont translate the player's cmod or mmod
        -- (only applies for mmod and cmod)
         if self.cmodValue or self.mmodValue then
            local v = self.cmodValue or self.mmodValue
            intendedXmodValue = findXmodEquivalent(v)
         end

        -- debug
        if true then
            SCREENMAN:SystemMessage(self.xmodValue or 0)
            SCREENMAN:SystemMessage(self.cmodValue or 0)
            SCREENMAN:SystemMessage(self.mmodValue or 0)
        end

        if self.xmodValue and not self.mmodValue then
            -- remove this line if you want to leave the xmod value people might already be set on alone
            setPlayerOptionsModValueAllLevels("XMod", intendedXmodValue)
        else
            setPlayerOptionsModValueAllLevels("XMod", intendedXmodValue)
        end

        -- failsafe keeps this actor from suddenly dying for no reason (might trigger EndCommand early)
        self:sleep(99999)
    end,
    EndCommand = function(self)
        -- occurs once this actor is killed (so basically the screen ends)
        if self.xmodValue and not self.mmodValue then
            -- reset back to xmod
            setPlayerOptionsModValueAllLevels("XMod", self.xmodValue)
        elseif self.cmodValue then
            -- reset back to cmod
            setPlayerOptionsModValueAllLevels("CMod", self.cmodValue)
        elseif self.mmodValue then
            -- reset back to mmod
            setPlayerOptionsModValueAllLevels("MMod", self.mmodValue)
        end
    end
}

return t